"""
------------------------------------------------------------------

April 2026, Amogh Morye

Copyright (c) 2026 by Cisco Systems, Inc.
All rights reserved.
------------------------------------------------------------------
"""


import os
import sys
import itertools
import string

try:
    from prettytable import PrettyTable

except ImportError:
    print('Please install "pip install prettytable", as it is required by this script')
    exit(1)


current_directory = "."

#### Function to check if the Primary version running on the AP is the one where this issue is observed or not.
####Returns True if the version is buggy.
def primary_version_check_func(filename):   
    file_path = os.path.join(current_directory, filename)
    primary_version_check = False
    primary_image = ""
    backup_image = ""
    if os.path.isfile(file_path): # Check if it's a file (and not a directory or a symbolic link)
                with open(file_path, 'r', encoding='utf-8', errors='ignore') as infile:
                    for line_num, line in enumerate(infile, 1):
                        if "AP Running Image     :" in line:
                            primary_image = line.split(":")[1].strip()
                        else:
                            continue

    prim_first_section = ""
    prim_second_section = ""
    prim_third_section = ""
    prim_fourth_section = ""

    ##print(primary_image)
    prim_first_section, prim_second_section, prim_third_section, prim_fourth_section = primary_image.split(".")

    if prim_first_section == "17" and prim_second_section == "12" and int(prim_third_section) <= 3:
        primary_version_check = False
    elif prim_first_section == "17" and prim_second_section == "12" and prim_third_section == "4" and int(prim_fourth_section) >= 213:
        primary_version_check = False
    elif prim_first_section == "17" and prim_second_section == "12" and prim_third_section == "5" and int(prim_fourth_section) >= 209:
        primary_version_check = False
    elif prim_first_section == "17" and prim_second_section == "12" and prim_third_section == "6" and int(prim_fourth_section) >= 201:
        primary_version_check = False    
    elif prim_first_section == "17" and prim_second_section == "15" and prim_third_section == "3" and int(prim_fourth_section) >= 212:
        primary_version_check = False
    elif prim_first_section == "17" and prim_second_section == "15" and prim_third_section == "4" and int(prim_fourth_section) >= 206:
        primary_version_check = False
    elif prim_first_section == "17" and prim_second_section == "15" and prim_third_section == "5":
        primary_version_check = False
    elif prim_first_section == "17" and prim_second_section == "18" and prim_third_section == "1" and int(prim_fourth_section) >= 203:
        primary_version_check = False
    elif prim_first_section == "17" and prim_second_section == "18" and prim_third_section == "2" and int(prim_fourth_section) >= 201:
        primary_version_check = False
    elif prim_first_section == "17" and int(prim_second_section) <= 9:
        primary_version_check = False
    else:
        primary_version_check =  True


    return primary_image, primary_version_check


#### Function to check if the Backup version running on the AP is the one where this issue is observed or not.
#### Returns True if the version is buggy.
def backup_version_check_func(filename):
    file_path = os.path.join(current_directory, filename)
    backup_version_check = False
    primary_image = ""
    backup_image = ""
    if os.path.isfile(file_path): # Check if it's a file (and not a directory or a symbolic link)
                with open(file_path, 'r', encoding='utf-8', errors='ignore') as infile:
                    for line_num, line in enumerate(infile, 1):
                        if "Backup Boot Image    :" in line:
                            #print(line)
                            backup_image = line.split(":")[1].strip()
                        else:
                            continue

    sec_first_section = ""
    sec_second_section = ""
    sec_third_section = ""
    sec_fourth_section = ""
    #print(filename)
    #print(backup_image)

    if not backup_image:
        backup_image = None
        backup_version_check = False
        return backup_image, backup_version_check
        
    sec_first_section, sec_second_section, sec_third_section, sec_fourth_section = backup_image.split(".")

    if sec_first_section == "17" and sec_second_section == "12" and int(sec_third_section) <= 3:
        backup_version_check = False
    elif sec_first_section == "17" and sec_second_section == "12" and sec_third_section == "4" and int(sec_fourth_section) >= 213:
        backup_version_check = False
    elif sec_first_section == "17" and sec_second_section == "12" and sec_third_section == "5" and int(sec_fourth_section) >= 209:
        backup_version_check = False
    elif sec_first_section == "17" and sec_second_section == "12" and sec_third_section == "6" and int(sec_fourth_section) >= 201:
        backup_version_check = False    
    elif sec_first_section == "17" and sec_second_section == "15" and sec_third_section == "3" and int(sec_fourth_section) >= 212:
        backup_version_check = False
    elif sec_first_section == "17" and sec_second_section == "15" and sec_third_section == "4" and int(sec_fourth_section) >= 206:
        backup_version_check = False
    elif sec_first_section == "17" and sec_second_section == "15" and sec_third_section == "5":
        backup_version_check = False
    elif sec_first_section == "17" and sec_second_section == "18" and sec_third_section == "1" and int(sec_fourth_section) >= 203:
        backup_version_check = False
    elif sec_first_section == "17" and sec_second_section == "18" and sec_third_section == "2" and int(sec_fourth_section) >= 201:
        backup_version_check = False
    elif sec_first_section == "17" and sec_second_section == "9" and sec_third_section == "7":
        backup_version_check = False
    else:
        backup_version_check =  True
        
    return backup_image, backup_version_check
       
#### Function to check if the cnssdaemon log file is present in the storage or not
#### Returns True if the file is present
def cnssdaemon_log_check_func(filename):
    file_path = os.path.join(current_directory, filename)
    cnssdaemon_log_check = False
    if os.path.isfile(file_path): # Check if it's a file (and not a directory or a symbolic link)
                with open(file_path, 'r', encoding='utf-8', errors='ignore') as infile:
                    for line_num, line in enumerate(infile, 1):
                        if "cnssdaemon.log" and "root" in line:
                            cnssdaemon_log_check = True
                            return cnssdaemon_log_check
                        else:
                            continue

    return cnssdaemon_log_check


#### Function to check if the current boot partition is part or part2
#### Returns True if it is part1                 
def current_boot_partition_check_func(filename):
    file_path = os.path.join(current_directory, filename)
    current_boot_partition_check = False
    partition = ""
    if os.path.isfile(file_path): # Check if it's a file (and not a directory or a symbolic link)
        with open(file_path, 'r', encoding='utf-8', errors='ignore') as infile:
            for line_num, line in enumerate(infile, 1):
                if "BOOT path-list:" in line:
                    partition = line.split(":")[1].strip()
                    if partition == "part1":
                        current_boot_partition_check = True
                    else:
                        current_boot_partition_check = False
                else:
                    continue
            
    return partition, current_boot_partition_check


#### Function to check the image integrity on the AP
#### Returns True if it has failed
def image_integrity_check_func(filename):
    try:
        file_path = os.path.join(current_directory, filename)
        image_integrity_check = False
        next_16_lines = []
        if os.path.isfile(file_path): # Check if it's a file (and not a directory or a symbolic link)
            with open(file_path, 'r', encoding='utf-8', errors='ignore') as infile:
                for line_num, line in enumerate(infile, 1):
                    if "show image integrity" in line:
                        next_25_lines = list(itertools.islice(infile, 25))
                    else:
                        continue

        show_ap_image_integrity_output_list = [item for item in next_25_lines if item.strip() != ""]

        part1_image = ((show_ap_image_integrity_output_list[1].split("(")[1]).split(")")[0]).strip(")")
        part1_integrity_version = show_ap_image_integrity_output_list[1].split(" ")[1].strip()
        part1_bin_integrity = show_ap_image_integrity_output_list[2].split(":")[1].strip()
        part1_ramfs_integrity = show_ap_image_integrity_output_list[3].split(":")[1].strip()
        part1_ioxtar_integrity = show_ap_image_integrity_output_list[4].split(":")[1].strip()

        part2_image = ((show_ap_image_integrity_output_list[5].split("(")[1]).split(")")[0]).strip(")")
        part2_integrity_version = show_ap_image_integrity_output_list[5].split(" ")[1].strip()
        part2_bin_integrity = show_ap_image_integrity_output_list[6].split(":")[1].strip()
        part2_ramfs_integrity = show_ap_image_integrity_output_list[7].split(":")[1].strip()
        part2_ioxtar_integrity = show_ap_image_integrity_output_list[8].split(":")[1].strip()

##        print(part1_image)
##        print(part1_integrity_version)
##        print(part1_bin_integrity)
##        print(part1_ramfs_integrity)
##        print(part1_ioxtar_integrity)
##        print(part2_image)
##        print(part2_integrity_version)
##        print(part2_bin_integrity)
##        print(part2_ramfs_integrity)
##        print(part2_ioxtar_integrity)
                
        primary_image, primary_image_check = primary_version_check_func(filename)
        backup_image, backup_image_check = backup_version_check_func(filename)
        part1_image_version_integrity_check = False
        part2_image_version_integrity_check = False

        if (part1_image == "Backup"):
            if(part1_integrity_version != backup_image):
                part1_image_version_integrity_check = True
        elif (part1_integrity_version != primary_image):
            part1_image_version_integrity_check = True

        if (part2_image == "Backup"):
            if(part2_integrity_version != backup_image):
                part2_image_version_integrity_check = True
        elif (part2_integrity_version != primary_image):
            part2_image_version_integrity_check = True


        if (part1_image_version_integrity_check == False and part2_image_version_integrity_check == False and part1_bin_integrity == "Good" and part1_ramfs_integrity == "Good" and part1_ioxtar_integrity == "Good" and part2_bin_integrity == "Good" and part2_ramfs_integrity == "Good" and part2_ioxtar_integrity == "Good"):
            image_integrity_check = False
        else:
            image_integrity_check = True

        return  image_integrity_check

    except Exception as e:
        ##print(show_ap_image_integrity_output_list)
        print(f"Error Message: {e}")
        print("Errored occurred during integrity check for: " + filename + ". Please check the version, model etc for this AP before proceeding with your upgrade")
        return None

#### Function to check the memory available on /part2
#### Returns True if it is less than 80MB
def part2_mem_utilization_check_func(filename):
    file_path = os.path.join(current_directory, filename)
    part2_mem_utilization_check = False
    if os.path.isfile(file_path): # Check if it's a file (and not a directory or a symbolic link)
        with open(file_path, 'r', encoding='utf-8', errors='ignore') as infile:
            for line_num, line in enumerate(infile, 1):
                if "/dev/ubivol/part2" in line:
                    #print(line)
                    mem_available = line.split()[3].rstrip(string.ascii_letters)
                    if float(mem_available) > 80:
                        part2_mem_utilization_check = False
                        return mem_available, part2_mem_utilization_check
                    else:
                        part2_mem_utilization_check = True
                        return mem_available, part2_mem_utilization_check
                else:
                   continue

#### Function to check if the AP is one of the affected models or not
#### Returns True if it is affected
def ap_model_check_func(filename):
    file_path = os.path.join(current_directory, filename)
    ap_model_check = False
    if os.path.isfile(file_path): # Check if it's a file (and not a directory or a symbolic link)
        with open(file_path, 'r', encoding='utf-8', errors='ignore') as infile:
            for line_num, line in enumerate(infile, 1):
                if "Cisco AP Software" in line:
                    ap_model = line.split(",")[1].strip()
                    if ap_model == "(ap1g6a)" or ap_model == "(ap1g6b)":
                        ap_model_check = True
                        #print(ap_model + str(ap_model_check))
                        return ap_model, ap_model_check
                    else:
                        ap_model_check = False
                        #print(ap_model + str(ap_model_check))
                        return ap_model, ap_model_check

    print(f"DEBUG: Function reached the end for {filename} without finding data.")

#### Function to get the device type from the Poller output
#### Returns ios, cos_qca, cos_bcm
def device_check_func(filename):
    #print(filename)
    file_path = os.path.join(current_directory, filename)
    device_check = False
    if os.path.isfile(file_path): # Check if it's a file (and not a directory or a symbolic link)
        with open(file_path, 'r', encoding='utf-8', errors='ignore') as infile:
            for line_num, line in enumerate(infile, 1):
                if "hostname=" in line:
                    #print(line)
                    device = (line.split(" ")[2].strip()).split("=")[1].strip("'")
                    return device

#### Function to get the AP's hostname
#### Returns the AP's hostname
def ap_hostname_func(filename):
    file_path = os.path.join(current_directory, filename)
    hostname = ""
    if os.path.isfile(file_path): # Check if it's a file (and not a directory or a symbolic link)
        with open(file_path, 'r', encoding='utf-8', errors='ignore') as infile:
            for line_num, line in enumerate(infile, 1):
                if "hostname=" in line:
                    hostname = (line.split(" ")[3].strip()).split("=")[1].strip("'")
                    return hostname

#### Function to write the output to the file
def write_to_output_file(content, output_filename):
    try:
        with open(output_filename, "a") as f:
            if type(content) is list:
                ##print("content is list")
                for item in content:
                    f.write(item + "\n")
            else:
                f.write(content)
            f.write("\n\n")
    except Exception as e:
        print(f"Error Message: {e}")
        print("Error occured while writing to the output file")

#### Function to run get the results fro all the previous functions and run them through the logic to detect potential harmful APs
def detect_aps(output_filename):

    try:
        if os.path.exists(output_filename):
            os.remove(output_filename)
            print(f"Existing file '{output_filename}' was found and deleted.")
        else:
            print(f"No existing file named '{output_filename}' found. Creating a new one.")
    except Exception as e:
        print(f"Warning: Could not delete existing file. Reason: {e}")

    
    Data = []
    script_name = "ap_detection_script_v4.py"
    script_name_exe = "ap_detection_script_v4.exe"

    #### Lists to store the results
    recovery_option_image_partition_swap = []
    recovery_option_devshell = []
    recovery_option_simple_archive_download = []
    recovery_option_image_integrity_check_failed = []
    recovery_option_partition_safe_but_clean_up_reccomended = []

    for entry_name in os.listdir(current_directory):
        Data_list = []
        file_path = os.path.join(current_directory, entry_name)
        if not os.path.isfile(file_path):
            continue
        
        # Skip the script file itself and the output log file
        if entry_name == script_name or entry_name == script_name_exe or entry_name == output_filename or "eWLC-9800" in entry_name or "Status_check_results" in entry_name or "ap_detection_script" in entry_name:
            continue

        device_check = device_check_func(file_path)
        #print(device_check)

        if device_check and device_check != "ios" and device_check != "cos_bcm":
            #print(device_check)
            #print(file_path)
            ap_model, ap_model_check = ap_model_check_func(file_path)
        else:
            continue

        
        
        ap_model, ap_model_check = ap_model_check_func(file_path)
        if ap_model_check == True:
            cnssdaemon_log_check = cnssdaemon_log_check_func(file_path)
            primary_image, primary_version_check = primary_version_check_func(file_path)
            backup_image, backup_version_check = backup_version_check_func(file_path)
            partition, current_boot_partition_check = current_boot_partition_check_func(file_path)
            image_integrity_check = image_integrity_check_func(file_path)
            mem_available, part2_mem_utilization_check = part2_mem_utilization_check_func(file_path)
            ap_hostname = ap_hostname_func(file_path)

            Data_list.append(ap_hostname)
            Data_list.append(ap_model)
            
            if ap_model_check == True:
                ap_model_check_status = "Susceptible"
                Data_list.append(str(ap_model_check) + " " + ap_model_check_status)
            else:
                ap_model_check_status = "Not Susceptible"
                Data_list.append(str(ap_model_check) + " " + ap_model_check_status)

            if cnssdaemon_log_check == True:
                cnssdaemon_log_check_status = "Susceptible"
                Data_list.append(str(cnssdaemon_log_check) + " " + cnssdaemon_log_check_status)
            else:
                cnssdaemon_log_check_status = "Not Susceptible"
                Data_list.append(str(cnssdaemon_log_check) + " " + cnssdaemon_log_check_status)

            if primary_version_check == True:
                primary_version_check_status = "Susceptible"
                Data_list.append(primary_image + "  " + str(primary_version_check) + " " + primary_version_check_status)
            else:
                primary_version_check_status = "Not Susceptible"
                Data_list.append(primary_image + "  " + str(primary_version_check) + " " + primary_version_check_status)
                
            if backup_version_check == True:
                backup_version_check_status = "Susceptible"
                Data_list.append(backup_image + "  " + str(backup_version_check) + " " + backup_version_check_status)
            else:
                backup_version_check_status = "Not Susceptible"
                Data_list.append(backup_image + "  " + str(backup_version_check) + " " + backup_version_check_status)
                
            if current_boot_partition_check == True:
                current_boot_partition_check_status = "Susceptible"
                Data_list.append(partition + "  " + str(current_boot_partition_check) + " " + current_boot_partition_check_status)
            else:
                current_boot_partition_check_status = "Not Susceptible"
                Data_list.append(partition + "  " + str(current_boot_partition_check) + " " + current_boot_partition_check_status)
                
            if image_integrity_check == True:
                image_integrity_check_status = "Susceptible"
                Data_list.append(str(image_integrity_check) + " " + image_integrity_check_status)
            else:
                image_integrity_check_status = "Not Susceptible"
                Data_list.append(str(image_integrity_check) + " " + image_integrity_check_status)

            if part2_mem_utilization_check == True:
                part2_mem_utilization_check_status = "Susceptible"
                Data_list.append(mem_available + "  " + str(part2_mem_utilization_check) + " " + part2_mem_utilization_check_status)
            else:
                part2_mem_utilization_check_status = "Not Susceptible"
                Data_list.append(mem_available + "  " + str(part2_mem_utilization_check) + " " + part2_mem_utilization_check_status)
                
            Data.append(Data_list) 

            if image_integrity_check == True:
                recovery_option_image_integrity_check_failed.append(ap_hostname)
                continue


        ##### Logic to determine which APs are affected
        if ap_model_check == True:
            if cnssdaemon_log_check == True:
                if primary_version_check == True:
                    if current_boot_partition_check == True:
                        if part2_mem_utilization_check == True:
                            if image_integrity_check == True:
                                recovery_option_devshell.append(ap_hostname)
                            elif image_integrity_check == False:
                                recovery_option_image_partition_swap.append(ap_hostname) 
                        elif part2_mem_utilization_check == False:
                            continue ############ No intervention needed
                    elif current_boot_partition_check == False:
                        if part2_mem_utilization_check == True:
                            recovery_option_partition_safe_but_clean_up_reccomended.append(ap_hostname)
                        if backup_version_check == True:
                            continue ############ No intervention needed
                elif primary_version_check == False:
                    if backup_version_check == True:
                        recovery_option_simple_archive_download.append(ap_hostname) 
                    elif backup_version_check == False:
                        continue ############ No intervention needed
            elif cnssdaemon_log_check == False:
                if backup_version_check == True:
                    recovery_option_simple_archive_download.append(ap_hostname) 
                elif backup_version_check == False:
                    continue ############ No intervention needed


    #### Tabulating the results
                
    headers = ["AP name", "AP model", "ap_model_check", "cnssdaemon_log_check", "primary_version_check", "backup_version_check", "current_boot_partition_check", "image_integrity_check", "part2_mem_utilization_check"]

    table = PrettyTable()
    table.field_names = headers

    for row in Data:
        table.add_row(row)

    # Print the table
    print(table)
    write_to_output_file(table.get_string(), output_filename)

    print()
    print()
    print()
    print()

    #### Printing the results in the for lists

    if recovery_option_image_partition_swap:
        print("--------Recovery with image partition swap(Option 1)--------")
        write_to_output_file("--------Recovery with image partition swap--------", output_filename)
        for item in recovery_option_image_partition_swap:
            print(item)
        write_to_output_file(recovery_option_image_partition_swap, output_filename)
        print()
        print()

    if recovery_option_devshell:
        print("--------Recovery with devshell(Option 2)--------")
        write_to_output_file("--------Recovery with devshell--------", output_filename)
        for item in recovery_option_devshell:
            print(item)
        write_to_output_file(recovery_option_devshell, output_filename)
        print()
        print()

    if recovery_option_simple_archive_download:
        print("--------Safe state but AP has buggy image in the backup partition(Option 3)--------")
        write_to_output_file("--------Safe state but AP has buggy image in the backup partition(Option 3)--------", output_filename)
        for item in recovery_option_simple_archive_download:
            print(item)
        write_to_output_file(recovery_option_simple_archive_download, output_filename)
        print()
        print()

    if recovery_option_image_integrity_check_failed:
        print("--------Image integrity check has failed for these APs(Option 4)--------")
        write_to_output_file("--------Image integrity check has failed for these APs(Option 4)--------", output_filename)
        for item in recovery_option_image_integrity_check_failed:
            print(item)
        write_to_output_file(recovery_option_image_integrity_check_failed, output_filename)
        print()
        print()

    if recovery_option_partition_safe_but_clean_up_reccomended:
        print("--------Partition is safe but the flash storage is low(Option 5)--------")
        write_to_output_file("--------Partition is safe but the flash storage is low(Option 5)--------", output_filename)
        for item in recovery_option_partition_safe_but_clean_up_reccomended:
            print(item)
        write_to_output_file(recovery_option_partition_safe_but_clean_up_reccomended, output_filename)



if __name__ == "__main__":       
    output_filename = "Status_check_results.log"
    for entry_name in os.listdir(current_directory):
        file_path = os.path.join(current_directory, entry_name)
        if not os.path.isfile(file_path):
            continue
        elif "eWLC-9800" in entry_name:
            controller_hostname = ap_hostname_func(file_path)
            output_filename = "Status_check_results" + "_" + controller_hostname + ".log"

    detect_aps(output_filename)
        
        
